#include "game.h"

s16 IWRAM_CODE Collision_GetAngle(s16 x1, s16 y1, s16 x2, s16 y2)
{
	return ArcTan2(x2-x1, y2-y1)>>8;
}

int IWRAM_CODE TriangleCollision(sTriangle* t, int tx, int ty, int x, int y)
{
	int ab;
	int ac;
	int ap;

	ab = Collision_GetAngle(t->x1+tx,t->y1+ty,t->x2+tx,t->y2+ty); //get angle for A -> B
	ac = Collision_GetAngle(t->x1+tx,t->y1+ty,t->x3+tx,t->y3+ty); //get angle for A -> C
	ap = Collision_GetAngle(t->x1+tx,t->y1+ty,x,y); //get angle for A -> P


	if((ab < ap && ap < ac) || (ac < ap && ap < ab) || (ap > ab && ap > ac && ((ab > ac + 0x8000) || (ac > ab + 0x8000))))
	{

		ab = Collision_GetAngle(t->x2+tx,t->y2+ty,t->x1+tx,t->y1+ty); //get angle for B -> A
		ac = Collision_GetAngle(t->x2+tx,t->y2+ty,t->x3+tx,t->y3+ty); //get angle for B -> C
		ap = Collision_GetAngle(t->x2+tx,t->y2+ty,x,y); //get angle for B -> P
		if((ab < ap && ap < ac) || (ac < ap && ap < ab) || (ap > ab && ap > ac && ((ab > ac + 0x8000) || (ac > ab + 0x8000)))) return 1;
	}

	return 0;
}

int IWRAM_CODE CheckModelCollision(sModel* m, int px, int py)
{
	sFace* f = m->f;
	while(f) {

		int max;
		int min;

		if(f->t.x1 >= f->t.x2 && f->t.x1 >= f->t.x3) max = f->t.x1;
		else if(f->t.x2 >= f->t.x1 && f->t.x2 >= f->t.x3) max = f->t.x2;
		else max = f->t.x3;

		if(f->t.x1 <= f->t.x2 && f->t.x1 <= f->t.x3) min = f->t.x1;
		else if(f->t.x2 <= f->t.x1 && f->t.x2 <= f->t.x3) min = f->t.x2;
		else min = f->t.x3;

		if(px >= min + m->x && px <= max + m->x)
		{
			if(f->t.y1 >= f->t.y2 && f->t.y1 >= f->t.y3) max = f->t.y1;
			else if(f->t.y2 >= f->t.y1 && f->t.y2 >= f->t.y3) max = f->t.y2;
			else max = f->t.y3;

			if(f->t.y1 <= f->t.y2 && f->t.y1 <= f->t.y3) min = f->t.y1;
			else if(f->t.y2 <= f->t.y1 && f->t.y2 <= f->t.y3) min = f->t.y2;
			else min = f->t.y3;

			if(px >= min + m->x && px <= max + m->x && py >= min + m->y && py <= max + m->y)
			{
				if(TriangleCollision(&f->t,m->x,m->y,px,py)) return 1;
			}
		}
		f = f->n;
	}
	return 0;
}

